/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModeloValoresCompReembolso
implements ModeloValores {
    private boolean inicializado;
    private final Map<Integer, ElementoNombreValor<String>> tiposDeComprobantes = new TreeMap<Integer, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposDeIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.inicializado = true;
        }
    }

    public void cargarTiposDeComprobantes(String tipoIdentificacion) {
        this.tiposDeComprobantes.clear();
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccionIdentificacion("1", tipoIdentificacion);
        for (Map.Entry comp : comprobantesObtenidos.entrySet()) {
            this.tiposDeComprobantes.put(Util.getInteger((String)comp.getKey()), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)((String)comp.getKey())));
        }
    }

    private void cargarTiposIdentificacion() {
        this.tiposDeIdentificacion.clear();
        this.tiposDeIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposDeIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposDeIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    public List<ElementoNombreValor<String>> getTiposDeComprobantes() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeComprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String codigoTipoComprobante) {
        return StringUtil.isNullOrEmpty((String)codigoTipoComprobante) ? null : this.tiposDeComprobantes.get(Util.getInteger(codigoTipoComprobante));
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeIdentificacion.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String codigoTipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)codigoTipoIdentificacion) ? null : this.tiposDeIdentificacion.get(codigoTipoIdentificacion);
    }
}

